---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-Daemon プロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.Daemon.pas` - Daemon プロバイダー実装（Delphi版、371行）
- E-02: `src/Horse.Provider.FPC.Daemon.pas` - Daemon プロバイダー実装（FPC版、288行）
- E-03: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（77行）
- E-04: `src/Horse.Constants.pas` - 定数定義（18行）
- E-05: `src/Horse.Provider.IOHandleSSL.pas` - SSL設定実装（162行）
- E-06: `src/Horse.pas` - メインユニット（117行）
- E-07: `samples/lazarus/winsvc/daemonmain.pas` - デーモンサンプル（62行）
- E-08: `samples/lazarus/winsvc/daemonmanager.pas` - マネージャーサンプル（30行）
- E-09: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HORSE_DAEMON コンパイルディレクティブで有効化（Delphi） | E-01: 5行目 `{$IF DEFINED(HORSE_DAEMON) AND NOT DEFINED(FPC)}` | ○ |
| C-02 | HORSE_DAEMON コンパイルディレクティブで有効化（FPC） | E-02: 9行目 `{$IF DEFINED(HORSE_DAEMON) AND DEFINED(FPC)}` | ○ |
| C-03 | TIdHTTPWebBrokerBridge を使用（Delphi版） | E-01: 10行目, 26行目 | ○ |
| C-04 | TFPHTTPServer を使用（FPC版） | E-02: 15行目, 31行目 | ○ |
| C-05 | デフォルトポートは9000 | E-04: 11行目 `DEFAULT_PORT = 9000` | ○ |
| C-06 | デフォルトホストは'0.0.0.0' | E-04: 10行目 `DEFAULT_HOST = '0.0.0.0'` | ○ |
| C-07 | HandleSignals によるシグナル処理 | E-01: 76行目, 93-106行目 | ○ |
| C-08 | SIGTERM でFRunning=False | E-01: 96-100行目 | ○ |
| C-09 | SIGHUP でログ出力 | E-01: 101-104行目 | ○ |
| C-10 | openlog/closelog によるsyslog連携 | E-01: 203行目, 276行目 | ○ |
| C-11 | ダブルフォークによるデーモン化 | E-01: 206-220行目 | ○ |
| C-12 | setsid によるセッション作成 | E-01: 211行目 | ○ |
| C-13 | umask(027) 設定 | E-01: 226行目 | ○ |
| C-14 | chdir('/') 設定 | E-01: 227行目 | ○ |
| C-15 | 標準入出力を /dev/null にリダイレクト | E-01: 221-225行目 | ○ |
| C-16 | TEvent による状態制御 | E-01: 66-67行目, 201行目, 266行目 | ○ |
| C-17 | FPC版でTHTTPServerThread使用 | E-02: 25-43行目, 241-257行目 | ○ |
| C-18 | IsRunning プロパティ（FPC版） | E-02: 93-96行目 | ○ |
| C-19 | SSL/TLS暗号化対応（Delphi版） | E-01: 181-193行目 | ○ |
| C-20 | KeepConnectionAlive初期値はTrue（Delphi版） | E-01: 366-367行目 | ○ |
| C-21 | デーモンメインとの関連 | E-09: 画面No.5とのマッピング | ○ |
| C-22 | デーモンマネージャーとの関連 | E-09: 画面No.6とのマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Delphi版とFPC版の実装差異（特にデーモン化処理）が正しく記述されているか
- [ ] POSIXシグナル処理の記述が実装と一致しているか
- [ ] syslog連携の記述が正確か
- [ ] ダブルフォークの目的と処理が正しく説明されているか
